 
<?php
/* 
Template Name: Página Simples
*/
get_header(); // chama o header.php do tema
?>
 

<?php date_default_timezone_set('America/Manaus');?>



 





<!DOCTYPE html>
<html lang="pt-BR">
<head>
<meta charset="UTF-8">

<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">

    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciamento de Fretes</title>




     
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/responsive/2.3.0/css/responsive.bootstrap5.min.css"/>
    <link rel="stylesheet" type="text/css" href="https://cdn.datatables.net/buttons/2.3.2/css/buttons.bootstrap5.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.3/css/jquery.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.0.1/css/buttons.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/select/1.3.3/css/select.dataTables.min.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.dataTables.min.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.0.1/js/buttons.html5.min.js"></script>
    <script src="https://cdn.datatables.net/select/1.3.3/js/dataTables.select.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>

  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>




 
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.3.1/js/bootstrap.bundle.min.js"></script>



 
 
 
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/l10n/pt.js"></script>
 
 
  




<!-- Offcanvas fora do loop -->
<div class="offcanvas offcanvas-end" id="demo" style="width: 40%;" data-bs-backdrop="true">
  <div class="offcanvas-header">
    <h3 id="frete-title">Frete - </h3>
    <button type="button" class="btn-close" data-bs-dismiss="offcanvas"></button>
  </div>
  <div class="offcanvas-body">
    <div id="loading-spinner" style="display: none; text-align: center;">
      <div class="spinner-border" role="status">
        <span class="visually-hidden">Loading...</span>
      </div>
    </div>
    <iframe id="frete-iframe" src="" width="100%" height="auto" style="border:none;" onload="hideSpinner()"></iframe>
  </div>
</div>








    <style>



 
 
 
 
.filter-container{
 
 
    background: aliceblue !important;
 
}



.ticket {
  width: 300px;
  height: auto;
  background-color: #f8f9fa;
  border: 2px dashed #000;

  border-radius: 15px;
  position: relative;
}

.ticket:before, .ticket:after {
  content: '';
  width: 15px;
  height: 15px;
  background-color: #ffffff;
  border-radius: 50%;
  position: absolute;
}

.ticket:before {
  top: 26px;
  left: -10px;
}

.ticket:after {
  top: 26px;
  right: -10px;
}



        table.dataTable thead th {
            white-space: nowrap;
        }
        table.dataTable tbody td {
            white-space: nowrap;
        }
        .filter-container {
            display: flex;
            flex-wrap: wrap;
            gap: 15px;
            margin-bottom: 10px;
            background: linear-gradient(to right, #f7f7f7, #e9e9e9);
            padding: 10px;
            border-radius: 10px;
        }
        .filter-group {
            display: flex;
            flex-direction: column;
            flex: 1;
            max-width: 200px;
        }
        .filter-group label {
            margin-bottom: 5px;
            font-weight: bold;
            color: #0056b3;
        }
        .filter-group select {
            padding: 5px;
            border: 1px solid #ced4da;
            border-radius: 4px;
            background: linear-gradient(to right, #ffffff, #e9e9e9);
        }
        .filter-group select#filter-data {
            background: linear-gradient(to right, #ffffff, #d3e0ea);
            border: 1px solid #007bff;
        }
        .dt-buttons {
            margin-bottom: 10px;
        }
        tfoot {
            font-weight: bold;
        }
        .modal {
            z-index: 1050; /* Bootstrap default modal z-index */
        }
        .modal-backdrop {
            z-index: 1040; /* Bootstrap default backdrop z-index */
        }
        /* Opcional: For�ar que o menu lateral tenha um �ndice z menor */
        #adminmenumain, #wpadminbar {
            z-index: 1;
        }
        .loading::after {
            content: '';
            position: absolute;
            top: 50%;
            left: 50%;
            width: 20px;
            height: 20px;
            border: 3px solid #ccc;
            border-top: 3px solid #000;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            transform: translate(-50%, -50%);
        }
        @keyframes spin {
            0% { transform: translate(-50%, -50%) rotate(0deg); }
            100% { transform: translate(-50%, -50%) rotate(360deg); }
        }
        .loading-container {
            position: relative;
        }
        .loading-container .loading {
            display: none;
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(255, 255, 255, 0.8);
            z-index: 10;
        }
        .loading-container.loading .loading {
            display: block;
        }
        .status-item {
            padding: 10px 20px;
            border-radius: 0px ;
            color: white;
            font-weight: bold;
            display: inline-block;
            text-align: center;
            width: 100%;
        }
        .total-faturado {
            background-color: #28a745; /* Verde */
        }
        .total-desconto {
            background-color: #007bff; /* Azul claro */
        }
        .total-lancados {
            background-color: #0056b3; /* Azul escuro */
        }
        .total-volumes {
            background-color: #ffc107; /* Amarelo */
            color: black;
        }
        .total-receber {
            background-color: #dc3545; /* Vermelho */
        }
        .total-pagamento {
            background-color: #adb5bd; /* Cinza */
            color: #0056b3;
        }
        .status-item2 {
            display: flex;
            align-items: center;
            border: 1px solid #ddd;
            border-radius: 0px 40px 40px 0px;
            height: 68px; /* Ajuste conforme necess�rio */
            padding: 0;
            margin-bottom: 20px; /* Espa�amento entre cards */
            background: aliceblue;
        }
        .status-item2 .icon-background {
            background-color: #fff; /* Fundo azul */
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            height: 100%;
            width: 100px; /* Largura do �cone */
            border-right: 1px solid #ddd;
        }
        .status-item2 .icon-size {
            width: 50px; /* Ajuste conforme necess�rio */
            height: auto;
        }
        .status-item2 .text-container {
            padding-left: 10px;
        }
        .status-indicator {
            display: inline-block;
            width: 20px;
            height: 20px;
            border-radius: 50%;
            margin-right: 5px;
            vertical-align: middle;
        }
        .status-pagamento-avista {
            background-color: #28a745;
        }
        .status-faturado-devendo {
            background-color: #dc3545;
        }
        .status-a-receber-devendo {
            background-color: #dc3545;
        }
        .status-quitado {
            background-color: #dc3545;
        }
        .status-text {
            display: inline-block;
            vertical-align: middle;
        }


body {
    overflow-x: hidden;
}


    </style>
</head>
<body>




 

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">


    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>


 <script>
            function updateDateTime() {
                var now = new Date();
                var dateTimeString = now.toLocaleString();
                document.getElementById('dateTimeDisplay').textContent = dateTimeString;
            }

            setInterval(updateDateTime, 1000);
            updateDateTime();
        </script>


    <div class="container-xxl">
        <br>
   <div class="d-flex justify-content-between align-items-center mb-1">
    <h5 class="mb-0"><i class="bi bi-box-seam display-7"></i> FILTROS</h5>
 

<?php
// Obt�m o usu�rio logado
$current_user = wp_get_current_user();

// Se N�O estiver na role 'grupo_encomenda', mostra o bot�o
if ( ! in_array( 'grupo_encomenda33333', (array) $current_user->roles, true ) ) :
?>
    <button style="display:" class="btn btn-link text-dark"
            type="button"
            data-toggle="collapse"
            data-target="#orderFilterSection"
            aria-expanded="false"
            aria-controls="orderFilterSection">
        <i class="fas fa-chevron-down"></i> Valores
    </button>
<?php
endif;
?>




</div>
     <div id="orderFilterSection" class="collapse ">

        <div class="status-container row">
            <div class="col-md-2 col-sm-6 mb-3">
                <div class="loading-container" id="total-faturado-container" >
                    <span class="status-item total-faturado ticket" style=" background-color: #000;"> Totaliza&ccedil;&atilde;o <br><span id="total-fretes">R$ 0,00</span></span>
                    <div class="loading"></div>
                </div>
            </div>



     <div class="col-md-2 col-sm-6 mb-3">
                <div class="loading-container" id="total-recebido-container">
                    <span class="status-item  total-faturado ticket">Recebido<br> <span id="total-recebido">R$ 0,00</span></span>
                    <div class="loading"></div>
                </div>
            </div>
            <div class="col-md-2 col-sm-6 mb-3">
                <div class="loading-container" id="total-receber-container ">
                    <span class="status-item total-receber ticket">A Receber <br><span id="total-receber">R$ 0,00</span></span>
                    <div class="loading"></div>
                </div>
            </div>


            <div class="col-md-2 col-sm-6 mb-3">
                <div class="loading-container" id="total-desconto-container">
                    <span class="status-item total-desconto ticket">Descontos <br><span id="total-desconto">R$ 0,00</span></span>
                    <div class="loading"></div>
                </div>
            </div>





            <div class="col-md-2 col-sm-6 mb-3"> 
                <div class="loading-container" id="total-lancados-container">
                    <span class="status-item total-lancados ticket ">Encomendas<br> <span id="total-lancados">0</span></span>
                    <div class="loading"></div>
                </div>
            </div>
            <div class="col-md-2 col-sm-6 mb-3">
                <div class="loading-container" id="total-volumes-container">
                    <span class="status-item total-volumes ticket">Volumes <br><span id="total-volumes">0</span></span>
                    <div class="loading"></div>
                </div>
            </div>
       
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="status-item2 loading-container">
                    <div class="icon-background" id="total-dinheiro-container">
                        <img src="<?php echo get_bloginfo('template_directory');?>/real.png" alt="Dinheiro" class="icon-size">
                    </div>
                    <div class="text-container">
                        <span>DINHEIRO</span><br>
                        <div class="loading"></div>
                        <span id="total-dinheiro">R$ 0,00</span>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="status-item2 loading-container">
                    <div class="icon-background" id="total-pix-container">
                        <img src="<?php echo get_bloginfo('template_directory');?>/pix.png" alt="Pix" class="icon-size">
                    </div>
                    <div class="text-container">
                        <span>PIX</span><br>
                        <div class="loading"></div>
                        <span id="total-pix">R$ 0,00</span>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="status-item2 loading-container">
                    <div class="icon-background" id="total-debito-container">
                        <img src="<?php echo get_bloginfo('template_directory');?>/debito.png" alt="D�bito" class="icon-size">
                    </div>
                    <div class="text-container">
                        <span>D&Eacute;BITO</span><br>
                        <div class="loading"></div>
                        <span id="total-debito">R$ 0,00</span>
                    </div>
                </div>
            </div>
            <div class="col-md-3 col-sm-6 mb-3">
                <div class="status-item2 loading-container">
                    <div class="icon-background" id="total-credito-container">
                        <img src="<?php echo get_bloginfo('template_directory');?>/bandeiras.jpg" alt="Cr�dito" class="icon-size">
                    </div>
                    <div class="text-container">
                        <span>CR&Eacute;DITO</span><br>
                        <div class="loading"></div>
                        <span id="total-credito">R$ 0,00</span>
                    </div>
                </div>
            </div>

</div>



        </div>
        <div class="filter-container">
            <div class="col-md-2 col-lg-2 filter-group">
                <label for="filter-data" class="form-label">Emiss&atilde;o:</label>
                <div class="loading-container" id="filter-data-container">




                    
<input type="text" id="filter-data2" class="form-control" value="Per&iacute;odo">


 
 
  


 

<script>
    // Inicializando o Flatpickr
    flatpickr("#filter-data2", {
        mode: "range",
        locale: "pt", // Definindo para portugu�s
        dateFormat: "d/m/Y", // Formato de data dd/mm/yyyy
        onClose: function(selectedDates, dateStr, instance) {
            if (selectedDates.length === 2) {
                // Formatar as datas em dois formatos diferentes
                var data_inicial_br = flatpickr.formatDate(selectedDates[0], "d/m/Y"); // Formato dd/mm/yyyy
                var data_final_br = flatpickr.formatDate(selectedDates[1], "d/m/Y");
                var data_inicial_int = flatpickr.formatDate(selectedDates[0], "Y-m-d"); // Formato yyyy-mm-dd
                var data_final_int = flatpickr.formatDate(selectedDates[1], "Y-m-d");

                // Obtendo a home URL do WordPress atrav�s do PHP, sem incluir a barra adicional no final
                var homeUrl = "<?php echo esc_url(home_url('filtroencomenda')); ?>";

                // Cria��o da URL com os par�metros de data
                var url = new URL(homeUrl);
                url.searchParams.set('data_inicial_br', data_inicial_br);
                url.searchParams.set('data_final_br', data_final_br);
                url.searchParams.set('data_inicial_int', data_inicial_int);
                url.searchParams.set('data_final_int', data_final_int);

                // Redirecionar para a URL com as datas selecionadas
                window.location.href = url.toString();
            }
        }
    });
</script>




   
 



                    <div class="loading"></div>
                </div>
            </div>
            <div class="col-md-2 col-lg-2 filter-group">
                <label for="filter-status" class="form-label">Status:</label>
                <select id="filter-status" class="form-select">
                    <option value="">Todos</option>
                </select>
            </div>


            <div class="col-md-2 col-lg-2 filter-group">
                <label for="filter-status" class="form-label">Origem:</label>
                <select id="filter-status-pg" class="form-select">
                    <option value="">Todos</option>
                </select>
            </div>



            <div class="col-md-2 col-lg-2 filter-group">
                <label for="filter-viagem" class="form-label">Destino:</label>
                <select id="filter-viagem" class="form-select">
                    <option value="">Todos</option>
                </select>
            </div>

 <div class="col-md-2 col-lg-2 filter-group">
                <label for="filter-destinatario" class="form-label">Entregue:</label>
                <select id="filter-destinatario" class="form-select">
                    <option value="">Todos</option>
                </select>
            </div>


            <div class="col-md-2 col-lg-2 filter-group">
                <label for="filter-cidade" class="form-label">Transporte:</label>
                <select id="filter-cidade" class="form-select">
                    <option value="">Todos</option>
                </select>
            </div>
           
        </div>


 








     


        <div class="table-responsive mt-2">
            <?php
            date_default_timezone_set('America/Manaus');
            ?>
            <br>
              <?php


// Capturar as datas da URL
$data_inicial = isset($_GET['data_inicial_int']) ? $_GET['data_inicial_int'] : '';
$data_final = isset($_GET['data_final_int']) ? $_GET['data_final_int'] : '';

// Verificar se as datas foram enviadas via GET
if ($data_inicial && $data_final) {
    // As datas j� est�o no formato Y-m-d, portanto, podem ser usadas diretamente
    $data_inicial_convertida = $data_inicial;
    $data_final_convertida = $data_final;
} else {
    // Se n�o houver GET, definir data inicia  e final para o m�s atual
//-- últimos 7 dias (hoje incluso)
$data_inicial_convertida = (new DateTime('-5 days'))->format('Y-m-d'); // 6+hoje = 7
$data_final_convertida   = (new DateTime('today'))->format('Y-m-d');

}

// Ajustar os argumentos da consulta com filtro de datas
$args2 = array(
    'post_type' => 'encomendas',
    'posts_per_page' => -1,
    'post_status' => 'publish', // apenas publicados

    'date_query' => array(
        array(
            'after'     => $data_inicial_convertida,
            'before'    => $data_final_convertida,
            'inclusive' => true,
        ),
    ),
    'meta_query' => array(
        array(
            'key'     => 'tipocat',
            'value'   => 'Encomenda',
            'compare' => '='
        )
    )
);

// Executar a consulta
$the_query = new WP_Query($args2);


if ($the_query->have_posts()) : 
?>

<div class="d-flex flex-column flex-md-row align-items-start align-items-md-center justify-content-between p-2 border rounded">
  
  <p class="mb-2 mb-md-0">
    Exibindo registros de pagamentos de:
    <?php echo date('d/m/Y', strtotime($data_inicial_convertida)); ?>
    até
    <?php echo date('d/m/Y', strtotime($data_final_convertida)); ?>
  </p>

  <div class="d-flex flex-wrap align-items-center gap-3 fs-6">
    <span class="d-flex align-items-center">
      <span class="me-1 rounded-circle" style="width:12px; height:12px; background-color:green;"></span>
      Pago e entregue
    </span>

    <span class="d-flex align-items-center">
      <span class="me-1 rounded-circle" style="width:12px; height:12px; background-color:orange;"></span>
      Pago, não entregue
    </span>

    <span class="d-flex align-items-center">
      <span class="me-1 rounded-circle" style="width:12px; height:12px; background-color:red;"></span>
      Não pago, e não entregue
    </span>
  </div>
</div>


<br>









<?php
/* helper para converter BRL string para float */
if ( ! function_exists('br_to_float') ) {
    function br_to_float($v) {
        if (empty($v) || !is_string($v)) return 0.0;
        $v = str_replace('.', '', $v);
        return (float) str_replace(',', '.', $v);
    }
}
?>
<table id="example" class="table table-striped table-bordered custom-datatable" style="width:100%; font-size: 13px;">
    <thead>
        <tr>
            <th><input type="checkbox" id="select-all"></th>
            <th>N&ordm;</th>
            <th>Emiss&atilde;o</th>
            <th>Operador</th>
            <th>Status PG</th>
            <th> Destinat&aacute;rio</th>
            <th>Tel do Remetente</th>
            <th>CPF do Remetente</th>
            <th>Remetente</th>
            <th>Tel Destinat&aacute;rio</th>
            <th>CPF do Destinat&aacute;rio</th>
            <th>Origem</th>
            <th>Destino</th>

      <th>Dinheiro</th>
 <th>Pix</th>
 <th>D&eacute;bito</th>
 <th>Cr&eacute;dito</th>

 <th>Tipo de Pagamento</th>
 <th>Valor Total de Produtos</th>
 <th>Valor Total Pago</th>
 <th>Valor Total Devido</th>
 <th>Valor do Desconto</th>
 <th>Quantidade Total de Produtos</th>
 <th>Produtos Selecionados</th>
 <th>Transporte</th>

 
 
 <th>Observa&ccedil;&otilde;es:</th> 
  <th>Setor</th> 


 <th>A&ccedil;&otilde;es</th>   



</tr>
 

 
    </thead>
    <tbody>
    <?php
    while ($the_query->have_posts()) : $the_query->the_post();
        $encomenda_id = get_the_ID();

        // Data de emiss�o
        $data_emissao = get_the_date('d/m/Y H:i');

        // Autor da encomenda
        $autor_encomenda = get_the_author_meta('display_name', get_post_field('post_author', $encomenda_id));

        // Obt�m os meta dados da encomenda
        $transporte = get_post_meta($encomenda_id, 'transporte', true);

$transporte_id = get_post_meta($encomenda_id, 'transporte', true);

if (!empty($transporte_id)) {
    $transporte_titulo = get_the_title($transporte_id);
    $transporte = $transporte_titulo;
} else {
   $transporte =  'Nenhum transporte encontrado.';
}



        $nome_remetente = get_post_meta($encomenda_id, 'nome_remetente', true);
        $contato_remetente = get_post_meta($encomenda_id, 'contato_remetente', true);
        $cpf_remetente = get_post_meta($encomenda_id, 'cpf_remetente', true);
        $nome_destinatario = get_post_meta($encomenda_id, 'nome_destinatario', true);
        $contato_destinatario = get_post_meta($encomenda_id, 'contato_destinatario', true);
        $cpf_destinatario = get_post_meta($encomenda_id, 'cpf_destinatario', true);
        $origem = get_post_meta($encomenda_id, 'origem', true);
        $destino = get_post_meta($encomenda_id, 'destino', true);
        $tipodepagamento = get_post_meta($encomenda_id, 'tipoP', true);
        $transporte = get_post_meta($encomenda_id, 'transporte', true);
        $valor_total_produtos = get_post_meta($encomenda_id, 'valor_total_produtos', true);
        $valor_total_pago = get_post_meta($encomenda_id, 'valor_total_pago', true);
        $valor_total_devido = get_post_meta($encomenda_id, 'valor_total_devido', true);
        $valor_desconto = get_post_meta($encomenda_id, 'valor_desconto', true);
        $valor_dinheiro = get_post_meta($encomenda_id, 'valor_dinheiro', true);
        $valor_debito = get_post_meta($encomenda_id, 'valor_debito', true);

        $valor_pix = get_post_meta($encomenda_id, 'valor_pix', true);
        
        $valor_credito = get_post_meta($encomenda_id, 'valor_credito', true);

         $status = get_post_meta($encomenda_id, 'status', true);

         $idunico = get_post_meta($encomenda_id, 'idunico', true);

        $obs = get_post_meta($encomenda_id, 'obs', true);

        $setor = get_post_meta($encomenda_id, 'setor', true);


      // Produtos selecionados
$produtos_json = get_post_meta($encomenda_id, 'produtos_selecionados', true);
$produtos_selecionados = json_decode($produtos_json, true);

// Preparar a lista de produtos e calcular a quantidade total
$lista_produtos = [];
$quantidade_total = 0;

if (is_array($produtos_selecionados)) {
    foreach ($produtos_selecionados as $produto_id => $detalhes) {
        $quantidade = isset($detalhes['quantidade']) ? $detalhes['quantidade'] : 0;
        $preco = isset($detalhes['preco']) ? $detalhes['preco'] : 0;

        // Obter o t�tulo do produto a partir do ID
        $nome_produto = get_the_title($produto_id);

        $lista_produtos[] = "{$quantidade} x {$nome_produto} (R$ {$preco})";

        // Acumula a quantidade total
        $quantidade_total += $quantidade;
    }
}

// Criar uma string �nica com todos os produtos, separados por <br>
$produtos = implode("<br>", $lista_produtos);
    ?>
        <tr>
            <td>



<input type="checkbox" class="select-row hidden" data-id="<?php echo $encomenda_id; ?>">



<?php if (floatval($valor_total_produtos) === floatval($valor_total_devido)) : ?>


<button class="dt-button pay-button" data-id="<?php echo $encomenda_id; ?>" style="background-color: rgb(33, 150, 243); color: rgb(255, 255, 255);">
      <span><i class="fas fa-credit-card"></i> Pagamento</span>
    </button>

<?php endif; ?>





</td>

<script>

// Evento de clique para o bot�o "Iniciar Pagamento"
$('.pay-button').on('click', function() {
  const itemId = $(this).data('id'); // Obtenha o ID do item do `data-id`

  // Seleciona automaticamente o checkbox correspondente
  $(`.select-row[data-id="${itemId}"]`).prop('checked', true);

  // Abre o modal
  $('#paymentModal').modal('show');
});


</script>
            <td><?php echo $encomenda_id; ?></td>
            <td><?php echo esc_html($data_emissao); ?></td>
            <td><?php echo esc_html($autor_encomenda); ?></td>
            <td><?php $valor_total_devido = floatval($valor_total_devido); // garante que � float

if ($valor_total_devido > 0) {
    echo "Falta Pagar";
} else {
    echo "Pago";
}; ?></td>



 <?php 
$valor_total_pago = (float) get_post_meta($encomenda_id, 'valor_total_pago', true);
$status           = (string) get_post_meta($encomenda_id, 'status', true);

// Lógica para determinar a classe do botão
if ($status === 'Recebida' && $valor_total_pago > 0) {
    $classe_btn = 'btn-warning'; // Laranja
} elseif ($status === 'Entregue' && $valor_total_pago > 0) {
    $classe_btn = 'btn-success'; // Verde
} elseif ($status === 'Recebida' && $valor_total_pago <= 0) {
    $classe_btn = 'btn-danger';  // Vermelho
} else {
    $classe_btn = 'btn-secondary'; // Padrão
}

// Link de destino
$link_btn = esc_url( site_url('cencomenda/?ent=nao&encomendaid=' . (int) $encomenda_id) );

// JS para popup centralizado 1200x700
$popup_js = "var w=1200,h=700,left=(screen.width-w)/2,top=(screen.height-h)/2;"
          . "window.open(this.href,'popupWindow','width='+w+',height='+h+',left='+left+',top='+top+',scrollbars=yes,resizable=yes');"
          . "return false;";
?>

<td>
  <?php if (in_array($classe_btn, ['btn-warning','btn-success'], true)) : ?>
    <a href="<?php echo $link_btn; ?>"
       class="btn btn-sm <?php echo esc_attr($classe_btn); ?> w-100 d-block"
       onclick="<?php echo esc_attr($popup_js); ?>">
       <?php echo esc_html($nome_destinatario); ?>
    </a>
  <?php else : ?>
    <span class="btn btn-sm <?php echo esc_attr($classe_btn); ?> w-100 d-block">
       <?php echo esc_html($nome_destinatario); ?>
    </span>
  <?php endif; ?>
</td>



            <td><?php echo esc_html($contato_remetente); ?></td>
            <td><?php echo esc_html($cpf_remetente); ?></td>
            <td> <?php echo esc_html($nome_remetente); ?></td>
            <td><?php echo esc_html($contato_destinatario); ?></td>
            <td><?php echo esc_html($cpf_destinatario); ?></td>
            <td><?php echo esc_html($origem); ?></td>
            <td><?php echo esc_html($destino); ?></td>

<td>R$ <?php echo number_format(br_to_float($valor_dinheiro), 2, ',', '.'); ?></td>
<td>R$ <?php echo number_format(br_to_float($valor_pix), 2, ',', '.'); ?></td>
<td>R$ <?php echo number_format(br_to_float($valor_debito), 2, ',', '.'); ?></td>
<td>R$ <?php echo number_format(br_to_float($valor_credito), 2, ',', '.'); ?></td>


            <td>


<?php 

  
if($status === "Recebida"){
    echo $status = "Nao";
};

if($status === "Entregue"){
    echo $status = "Sim";
}

?>


</td>
            <td>R$ <?php echo number_format(floatval($valor_total_produtos), 2, ',', '.'); ?></td>
            <td>R$ <?php echo number_format(floatval($valor_total_pago), 2, ',', '.'); ?></td>
            <td>R$ <?php echo number_format(floatval($valor_total_devido), 2, ',', '.'); ?></td>
            <td>R$ <?php echo number_format(floatval($valor_desconto), 2, ',', '.'); ?></td>
            <td><?php echo $quantidade_total; ?></td>
            <td><?php echo $produtos; ?></td>
            <td><?php echo get_the_title($transporte); ?></td>
            <td><?php echo $obs; ?></td>
            <td><?php echo $setor; ?></td>


 

            <td>

 <?php
$valor_total_pago = floatval(get_post_meta($encomenda_id, 'valor_total_pago', true));
$valor_total_produtos = floatval(get_post_meta($encomenda_id, 'valor_total_produtos', true));
$status = get_post_meta($encomenda_id, 'status', true);
?>

<?php if ($valor_total_pago === $valor_total_produtos) : ?>
    <?php if ($status !== 'Entregue') : ?>
        <!-- Ainda n�o foi entregue, mostrar bot�o laranja para entregar -->
        <button class="btn btn-warning view-post-btn"
            onclick="window.location.href='<?php echo esc_url(site_url('cencomenda?ent=ok&envio=destok&encomendaid=' . $encomenda_id)); ?>'">
            Entrega
        </button>
    <?php else : ?>
        <!-- J� entregue, apenas visualizar -->
       
    <?php endif; ?>





<?php endif; ?>

 
<button class="btn btn-secondary view-post-btn" type="button"
  onclick="window.open('<?php echo esc_js( esc_url( site_url('cencomenda?ent=nao&encomendaid=' . $encomenda_id) ) ); ?>',
                       'popupWindow',
                       'width=1200,height=700,scrollbars=yes,resizable=yes');">
  Visualizar
</button>



<a href="<?php echo get_delete_post_link($encomenda_id); ?>" 
   class="btn btn-danger"
   onclick="return confirm('Tem certeza que deseja deletar esta encomenda?')">
   Deletar
</a>

 
<!--
 
<button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#modalHistorico_<?php echo $encomenda_id; ?>">
  Cancelar
</button>
 -->



</td>
        </tr>




<!-- Bot�o para abrir o modal -->
 <!-- Modal -->
<div class="modal fade" id="modalHistorico_<?php echo $encomenda_id; ?>" tabindex="-1" aria-labelledby="modalHistoricoLabel_<?php echo $encomenda_id; ?>" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalHistoricoLabel_<?php echo $encomenda_id; ?>">Hist�rico de Encomenda</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Fechar"></button>
      </div>
      <div class="modal-body">
        <form method="post">
          <label for="historicoInput_<?php echo $encomenda_id; ?>">Digite o hist�rico:</label>
          <input type="text" id="historicoInput_<?php echo $encomenda_id; ?>" name="historico" class="form-control" required>
          <input type="hidden" name="encomenda_id" value="<?php echo $encomenda_id; ?>">
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Fechar</button>
        <button type="submit" name="confirmarHistorico" class="btn btn-primary">Confirmar exclus�o</button>
        </form>
      </div>
    </div>
  </div>
</div>


    <?php
    endwhile;
    ?>
    </tbody>
</table>



 





<?php else : ?>
    <p>Nenhuma encomenda encontrada.</p>
<?php endif; ?>

<?php wp_reset_postdata(); ?>


        </div>
    </div>

 



<script>
    function mostrarModal(id) {
        var modal = document.getElementById('modalHistorico_' + id);
        if (modal) {
            modal.style.display = 'block';
        }
    }

    function fecharModal(id) {
        var modal = document.getElementById('modalHistorico_' + id);
        if (modal) {
            modal.style.display = 'none';
        }
    }
</script>





<?php
// Verifica se o bot�o foi clicado e se o hist�rico foi enviado
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirmarHistorico'])) {
    if (!empty($_POST['historico'])) {
        $historico = sanitize_text_field($_POST['historico']);
        $encomenda_id = intval($_POST['encomenda_id']); // ID da encomenda original

        // Aqui voc� pode ajustar as vari�veis conforme necess�rio
        $valor_total_pago = get_post_meta($encomenda_id, 'valor_total_pago', true);
        $valor_dinheiro = get_post_meta($encomenda_id, 'valor_dinheiro', true);
        $valor_pix = get_post_meta($encomenda_id, 'valor_pix', true);
        $valor_debito = get_post_meta($encomenda_id, 'valor_debito', true);
        $valor_credito = get_post_meta($encomenda_id, 'valor_credito', true);
        $origem = get_post_meta($encomenda_id, 'origem', true);
        $destino = get_post_meta($encomenda_id, 'destino', true);

        // Insere um novo post do tipo 'avulsos'
        $post_data = array(
            'post_type'     => 'avulsos',
            'post_title'    => 'Registro de ' . current_time('d/m/Y H:i'),
            'post_status'   => 'publish',
            'meta_input'    => array(
                'valor'     => number_format(floatval($valor_total_pago), 2, ',', '.'),
                'avulso_dinheiro' => esc_html($valor_dinheiro ? $valor_dinheiro : '0,00'),
                'avulso_pix' => esc_html($valor_pix ? $valor_pix : '0,00'),
                'avulso_debito' => esc_html($valor_debito ? $valor_debito : '0,00'),
                'avulso_credito' => esc_html($valor_credito ? $valor_credito : '0,00'),
                'historico' => $historico . ' - ' . $origem . ' - ' . $destino,
                'tipo'      => 'Cancelado',
                'usuario'   => wp_get_current_user()->display_name
            ),
        );

        $post_id = wp_insert_post($post_data);

        if ($post_id) {
            // Exclui o post original ap�s criar o post avulso
            $deleted = wp_delete_post($encomenda_id, true); // O segundo par�metro 'true' exclui permanentemente o post

            if ($deleted) {
                // Adiciona um script JavaScript para recarregar a p�gina se a exclus�o for bem-sucedida
                echo '<div class="notice notice-success">Post criado com sucesso e encomenda original exclu�da!</div>';
                echo '<script type="text/javascript">
                        setTimeout(function() {
                            window.location.reload();
                        }, 100); // Recarrega a p�gina ap�s 1 segundo
                      </script>';
            } else {
                echo '<div class="notice notice-error">Erro ao excluir a encomenda original.</div>';
            }
        } else {
            echo '<div class="notice notice-error">Erro ao criar o post avulso.</div>';
        }
    } else {
        echo '<div class="notice notice-error">O campo hist�rico � obrigat�rio.</div>';
    }
}
?>















 

    <!-- Modal para Adicionar Novo Post -->
    <div class="modal fade" id="addPostModal" tabindex="-1" aria-labelledby="addPostModalLabel" aria-hidden="true">
        <div class="modal-dialog" role="document" style="max-width: 96%;">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <iframe id="addPostIframe" src="" width="100%" height="600px" frameborder="0"></iframe>
                </div>
            </div>
        </div>
    </div>

 

    <script>
      jQuery(document).ready(function($) {
    function formatCurrency(value) {
        return value.toLocaleString('pt-BR', { style: 'currency', currency: 'BRL' });
    }

    function intVal(i) {
        if (typeof i === 'string') {
            // Remove o simbolo da moeda, os separadores de milhar e substitui a virgula decimal por ponto
            i = i.replace(/R\$\s?/, '').replace(/\./g, '').replace(',', '.');
            return parseFloat(i) || 0;
        } else if (typeof i === 'number') {
            return i;
        }
        return 0;
    }

    function updateTotals(api) {
       

   // Obter o n�mero de linhas vis�veis ap�s a aplica��o dos filtros
var totalLancados = api.rows({ search: 'applied' }).data().length;

 


        var totalVolumes = api
            .column(22, { search: 'applied' })
            .data()
            .reduce(function (a, b) {
                return intVal(a) + intVal(b);
            }, 0) ;

var totalFretes = [19,20].reduce(function (total, colIndex) {
    return total + api
        .column(colIndex, { search: 'applied' })
        .data()
        .reduce(function (a, b) {
            return intVal(a) + intVal(b);
        }, 0);
}, 0);

var totalRecebidos = [19].reduce(function (total, colIndex) {
    return total + api
        .column(colIndex, { search: 'applied' })
        .data()
        .reduce(function (a, b) {
            return intVal(a) + intVal(b);
        }, 0);
}, 0);

var totalReceber = [20].reduce(function (total, colIndex) {
    return total + api
        .column(colIndex, { search: 'applied' })
        .data()
        .reduce(function (a, b) {
            return intVal(a) + intVal(b);
        }, 0);
}, 0);

var totalDesconto = api
    .column(21, { search: 'applied' })
    .data()
    .reduce(function (a, b) {
        return intVal(a) + intVal(b);
    }, 0);
        var totalDinheiro = api
            .column(13, { search: 'applied' })
            .data()
            .reduce(function (a, b) {
                return intVal(a) + intVal(b);
            }, 0) ;

        var totalPix = api
            .column(14, { search: 'applied' })
            .data()
            .reduce(function (a, b) {
                return intVal(a) + intVal(b);
            }, 0) ;

        var totalDebito = api
            .column(15, { search: 'applied' })
            .data()
            .reduce(function (a, b) {
                return intVal(a) + intVal(b);
            }, 0) ;

        var totalCredito = api
            .column(16, { search: 'applied' })
            .data()
            .reduce(function (a, b) {
                return intVal(a) + intVal(b);
            }, 0) ;

        // Atualiza os valores na interface com a formata��o correta
        $('#total-lancados').html((totalLancados));
        $('#total-volumes').html((totalVolumes));
        $('#total-fretes').html(formatCurrency(totalFretes));
        $('#total-recebido').html(formatCurrency(totalRecebidos));
        $('#total-receber').html(formatCurrency(totalReceber));
        $('#total-desconto').html(formatCurrency(totalDesconto));
        $('#total-dinheiro').html(formatCurrency(totalDinheiro));
        $('#total-pix').html(formatCurrency(totalPix));
        $('#total-debito').html(formatCurrency(totalDebito));
        $('#total-credito').html(formatCurrency(totalCredito));
    }
 




            function updateTotalRecords(api) {
                var totalRecords = api.rows({ search: 'applied' }).data().length;
 
            }

            var table = $('#example').DataTable({


              "order": [[3, "desc"]], // Ordena pela primeira coluna em ordem ascendente

                dom: 'Bfrtip',
                 
                buttons: [ 





////////////
{
    text: '<i class="fas fa-credit-card"></i>',
    className: '', // Classe Bootstrap base para bot�o
    init: function(api, node, config) {
        $(node).attr('id', 'pay-button'); // Atribui o ID 'pay-button' ao bot�o inteiro
        $(node).css({
            'background-color': '#2196F3', // Azul Material Design
            'color': '#ffffff', // Cor do texto branca
 
 
 
 
 
        });
    },
},


  


 {
  extend: 'print',
  text: '<i class="fas fa-print"></i> Protocolo',
  exportOptions: { modifier: { page: 'all' } },
  customize: function (win) {
    const tableApi = $('#example').DataTable();

    /* limpeza + estilo global */
    $(win.document.body).find('h1, footer, .footer-text, table').remove();
    $(win.document.body).css({ fontSize: '18px', margin: '3px' });

    /* evita quebras de página */
    $(win.document.head).append(`
     <style>
    .protocolo-bloco { page-break-inside: avoid; break-inside: avoid; }

    .circulos-bloco {
      display: inline-flex;
      gap: 14px;
      margin-bottom: 10px;
      align-items: center;
    }

    .circulo-id,
    .circulo-setor {
      display: inline-block;
      min-width: 40px;
      height: 40px;
      line-height: 38px;
      border: 2px solid #000;
      border-radius: 50%;
      text-align: center;
      font-weight: bold;
      font-size: 16px;
      padding: 0 5px;
      transform: rotate(-2deg);
    }

    .circulo-id {
      background-color: #f2f2f2;
    }

    .circulo-setor {
      background-color: #d1ecf1;
      border-color: #17a2b8;
      color: #0c5460;
    }
  </style>
    `);

    /* cabeçalho geral */
    const dataInicial = $('#filter-data-inicial').val() || 'Início';
    const dataFinal   = $('#filter-data-final').val()   || 'Hoje';
    const origem      = $('#filter-status-pg').val()    || 'Todos';
    const destino     = $('#filter-viagem').val()       || 'Todos';
    const transporte  = $('#filter-destinatario').val() || 'Todos';

    const header = `
      <div style="text-align:center; margin-bottom:15px;">
        <h1 style="font-size:20pt;">PROTOCOLO DE ENCOMENDAS</h1>
        <p style="font-size:14pt;">Exibindo registros de: ${dataInicial} até ${dataFinal}</p>
        <p style="font-size:12pt;">
          <strong>Origem:</strong> ${origem} &nbsp;|&nbsp;
          <strong>Destino:</strong> ${destino} &nbsp;|&nbsp;
          <strong>Transporte:</strong> ${transporte}
        </p>
        <hr style="margin-top:10px;">
      </div>
    `;

    let protocoloHTML = '';

/* Coleta e ordena os dados pelo número (ID) */
const dadosOrdenados = tableApi
  .rows({ search: 'applied' })
  .data()
  .toArray()
  .sort((a, b) => {
    const idA = parseInt(a[1]?.replace(/\D/g, '') || 0); // remove não números
    const idB = parseInt(b[1]?.replace(/\D/g, '') || 0);
    return idA - idB;
  });

/* Gera os blocos ordenados */
dadosOrdenados.forEach(d => {
  const numero        = d[1]?.trim();                 // ID
  const remetente     = $('<div>').html(d[8]).text().trim();
  const destinatario  = $('<div>').html(d[5]).text().trim();
  const local         = $('<div>').html(d[12]).text().trim();
  const situacao      = $('<div>').html(d[4]).text().trim();
  const produtosHtml  = d[23] || '';
  const total         = $('<div>').html(d[18]).text().trim();
  const pago          = $('<div>').html(d[19]).text().trim();
  const desconto      = $('<div>').html(d[21]).text().trim();
  const devedor       = $('<div>').html(d[20]).text().trim();
  const setor         = $('<div>').html(d[26]).text().trim();

  /* monta tabela de produtos */
  let produtosTabela = '';
  (produtosHtml ? produtosHtml.split(/<br\s*\/?>/i).filter(x => x.trim()) : [])
    .forEach(p => {
      const m = p.match(/(\d+(?:[\.,]\d+)?)\s+x\s+(.+?)\s+\(R\$\s?([\d,\.]+)\)/);
      if (!m) return;
      const qtd   = parseFloat(m[1].replace(',', '.')).toFixed(3);
      const desc  = m[2];
      const valor = parseFloat(m[3].replace('.', '').replace(',', '.')).toFixed(2);
      const tot   = (parseFloat(qtd) * parseFloat(valor)).toFixed(2);

      produtosTabela += `
        <tr>
          <td>${desc}</td><td>${qtd}</td><td>R$ ${valor}</td>
          <td>R$ ${tot}</td><td>${desconto}</td><td>${pago}</td>
          <td>${total}</td><td>${devedor}</td><td>${local}</td>
        </tr>`;
    });

  if (!produtosTabela) return;

  protocoloHTML += `
    <div class="protocolo-bloco" style="border:1px solid #000; padding:15px; margin-bottom:30px;">
      <div style="margin-bottom:10px;">
        <div class="circulos-bloco">
          <span class="circulo-id">${numero}</span>
          <span class="circulo-setor">${setor}</span>
        </div>

        <strong>Rem.:</strong> ${remetente}
        <strong>Dest.:</strong> ${destinatario} &nbsp;&nbsp;
        <strong>Local:</strong> <span style="background:orange; padding:2px 8px;">${local}</span> &nbsp;&nbsp;
        <strong>Situação:</strong> ${situacao}
      </div>

      <table border="1" style="width:100%; border-collapse:collapse; font-size:12px;">
        <thead>
          <tr style="background:#eee;">
            <th>Descrição</th><th>Qtd</th><th>Valor</th><th>Total</th>
            <th>Desconto</th><th>Pago</th><th>Nominal</th><th>Devedor</th><th>Local</th>
          </tr>
        </thead>
        <tbody>${produtosTabela}</tbody>
      </table>

      <div style="margin-top:30px;">
        <strong>DOC:</strong> ___________________________________________________________ &nbsp;&nbsp;
        <strong>DATA:</strong> _________________________________
        <br> <br><strong>ASS:</strong> ________________________________________________________________________________________
      </div>
    </div>`;
});

$(win.document.body).html(header + protocoloHTML);

  }
},


{
  extend: 'print',
  text: '<i class="fas fa-print"></i> Listagem Encomenda',

  exportOptions: {
    modifier: {
      page: 'all' // Exibe todos os dados filtrados, não só da página atual
    }
  },

  customize: function (win) {
    const tableApi = $('#example').DataTable();

    /* -- LIMPA A PÁGINA DE IMPRESSÃO -- */
    $(win.document.body)
      .find('h1, footer, .footer-text, table').remove()
      .end()
      .css({ 'font-size': '20pt', margin: 0 });

    /* -- CAPTURA FILTROS DO FORM -- */
    const origem     = $('#filter-status-pg').val()    || 'Todos';
    const destino    = $('#filter-viagem').val()       || 'Todos';
    const transporte = $('#filter-destinatario').val() || 'Todos';

    /* -- CABEÇALHO IMPRESSO -- */
    const headerContent = `
      <div style="text-align:center;margin-bottom:15px;">
        <h1 style="font-size:25pt;margin:0;">Listagem de Encomendas (Tabela)</h1>
        <p style="font-size:25pt;margin:4px 0;">
          Exibindo registros filtrados
        </p>
        <p style="font-size:18pt;margin:2px 0;">
          <strong>Origem:</strong> ${origem} &nbsp;|&nbsp;
          <strong>Destino:</strong> ${destino} &nbsp;|&nbsp;
          <strong>Transporte:</strong> ${transporte}
        </p>
      </div>`;

    /* -- TABELA: 25% Nº + 75% Destinatário -- */
    let tableContent = `
      <table style="width:100%;border-collapse:collapse;font-size:27pt;table-layout:fixed;">
        <colgroup>
          <col style="width:25%;">
          <col style="width:75%;">
        </colgroup>
        <thead>
          <tr>
            <th style="border:1px solid #000;padding:4px;text-align:center;">N</th>
            <th style="border:1px solid #000;padding:4px;">Destinatário</th>
          </tr>
        </thead>
        <tbody>`;

    /* -- Pega dados filtrados e ordena pelo destinatário (coluna 5) -- */
    let rowsData = [];
    tableApi.rows({ search: 'applied' }).every(function () {
      const data = this.data();
      rowsData.push({
        numero: data[1]?.trim(),
        nome: $('<div>').html(data[5]).text().trim()
      });
    });

    rowsData.sort((a, b) => a.nome.localeCompare(b.nome, 'pt-BR'));

    /* -- Monta as linhas -- */
    rowsData.forEach(row => {
      tableContent += `
        <tr>
          <td style="border:1px solid #000;padding:4px;text-align:center;">${row.numero}</td>
          <td style="border:1px solid #000;padding:4px 6px;white-space:nowrap;overflow:hidden;text-overflow:ellipsis;">
            ${row.nome}
          </td>
        </tr>`;
    });

    tableContent += `</tbody></table>`;

    /* -- INJETA O CONTEÚDO COMPLETO -- */
    $(win.document.body).prepend(headerContent + tableContent);
  }
}











 



  





 

                ],
                select: true,
                responsive: true,
                language: {
                    "sEmptyTable": "Nenhum registro encontrado",
                    "sInfo": "Mostrando de _START_ ate _END_ de _TOTAL_ registros",
                    "sInfoEmpty": "Mostrando 0 ate 0 de 0 registros",
                    "sInfoFiltered": "(Filtrados de _MAX_ registros)",
                    "sInfoPostFix": "",
                    "sInfoThousands": ".",
                    "sLengthMenu": "_MENU_ resultados por p�gina",
                    "sLoadingRecords": "Carregando...",
                    "sProcessing": "Processando...",
                    "sZeroRecords": "Nenhum registro encontrado",
                    "sSearch": "Pesquisar",
                    "oPaginate": {
                        "sNext": "Proximo",
                        "sPrevious": "Anterior",
                        "sFirst": "Primeiro",
                        "sLast": "�ltimo",


                    },
                    "oAria": {
                        "sSortAscending": ": Ordenar colunas de forma ascendente",
                        "sSortDescending": ": Ordenar colunas de forma descendente"
                    },
                    "buttons": {
                        "copyTitle": 'Copiar linhas',
                        "copySuccess": {
                            "_": '%d linhas copiadas',
                            "1": '1 linha copiada'
                        }
                    }
                },
                drawCallback: function(settings) {
                    var api = this.api();
                    updateTotals(api);
                    updateTotalRecords(api);
                }
            });







            

/* === INSIRA AQUI o bloco com os rádios + lógica de filtragem === */
    (function () {

        /* injeta os rádios na barra de pesquisa */
        $('#example_filter').prepend(`
          <div id="search-scope" style="display:inline-block;margin-right:12px;">
            <label class="me-2"><input type="radio" name="scope" value="all"  checked> Tudo</label>
            <label class="me-2"><input type="radio" name="scope" value="dest"> Dest.</label>
            <label class="me-2"><input type="radio" name="scope" value="rem"> Remet.</label>
          </div>
        `);

        const $filterInput = $('#example_filter input[type="search"]');

        function filtrar() {
            const texto  = $filterInput.val();
            const escopo = $('input[name="scope"]:checked').val();

            table.search('');
            table.columns().search('');

            if (escopo === 'dest') {          // Destinatário → coluna 5
                table.column(5).search(texto, true, false).draw();
            } else if (escopo === 'rem') {    // Remetente → coluna 8
                table.column(8).search(texto, true, false).draw();
            } else {                          // Global
                table.search(texto, true, false).draw();
            }
        }

        $filterInput.off('keyup.DT').on('keyup', filtrar);
        $(document).on('change', 'input[name="scope"]', function () {
            filtrar();
            $filterInput.trigger('focus');
        });
    })();


    

            // Fun��o para impress�o do registro
            function printRecord(data) {
                var printContent = `
                    <div style="padding: 20px; font-family: Arial, sans-serif;">
                        <h1 style="text-align: center; color: #333;">Detalhes do Frete ${data[0]}</h1>
                        <table style="width: 100%; border-collapse: collapse;">
                            <tbody>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">Nome do Frete:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[0]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">Remetente:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[1]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">Destinat&aacute;rio:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[2]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">Emiss&atilde;o:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[3]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">Viagem:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[4]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">Pagamento:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[5]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">Faturado:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[6]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">Bruto:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[7]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">L�quido:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[8]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">Desconto:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[9]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">A Receber:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[10]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">Conferente:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[11]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">Volumes:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[12]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">Tipo de Pagamento:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[13]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">Dinheiro:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[14]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">Pix:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[15]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">D�bito:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[16]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">Cr�dito:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[17]}</td>
                                </tr>
                                <tr>
                                    <th style="text-align: left; padding: 8px; border: 1px solid #ddd;">Itens do Produto:</th>
                                    <td style="padding: 8px; border: 1px solid #ddd;">${data[18]}</td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                `;

                var printWindow = window.open('', '_blank', 'height=600,width=800');
                printWindow.document.write('<html><head><title>Print</title>');
                printWindow.document.write('<style>body { font-family: Arial, sans-serif; } th { background-color: #f2f2f2; } th, td { padding: 10px; }</style>');
                printWindow.document.write('</head><body>');
                printWindow.document.write(printContent);
                printWindow.document.write('</body></html>');
                printWindow.document.close();
                printWindow.print();
            }

            // Evento de clique para os bot�es dentro das c�lulas com a classe "liberar"
            $('#example tbody').on('click', 'button.liberar', function(e) {
                e.preventDefault();
                var post_id = $(this).data('post-id');
                var data = table.row($(this).closest('tr')).data();

                if ($(this).hasClass('print-post-btn')) {
                    printRecord(data);
                } else if ($(this).hasClass('print-selected-btn')) {
                    var selectedData = table.rows({ selected: true }).data().toArray();
                    selectedData.forEach(function(row) {
                        if (row[0] == post_id) {
                            printRecord(row);
                        }
                    });
                } else if ($(this).hasClass('edit-post-btn')) {
                    //alert('Editar post com ID: ' + post_id);
                }
            });

            // Prevenir clique em outras colunas que n�o sejam a primeira coluna, com classe "liberar", ou que contenham bot�es
            $('#example tbody').on('click', 'td:not(:first-child):not(.liberar):not(:has(button))', function(e) {
                e.stopPropagation();
            });

            // Capturar evento de abertura da linha responsiva
            $('#example').on('responsive-display', function(e, datatable, row, showHide, update) {
                if (showHide) { // Se a linha est� sendo aberta
                    var rowData = row.data();
                    var post_id = rowData[0];
                    var printBtn = row.node().querySelector('.print-selected-btn');

                    if (printBtn) {
                        printBtn.click(); // Simular clique no bot�o de impress�o
                    }
                }
            });

            // Fun��o para adicionar op��es de filtro baseadas nos valores de uma coluna
            function addColumnFilter(columnIndex, selectId) {
                var column = table.column(columnIndex);
                var select = $(selectId);

                column.data().unique().sort().each(function (d, j) {
                    select.append('<option value="' + d + '">' + d + '</option>');
                });

                // Evento para filtrar a tabela com base na sele��o
                select.on('change', function () {
                    var val = $.fn.dataTable.util.escapeRegex($(this).val());
                    column.search(val ? '^' + val + '$' : '', true, false).draw();
                    updateTotals(table);
                    updateTotalRecords(table);
                });
            }

            // Adiciona filtros para as colunas desejadas
            addColumnFilter(4, '#filter-status'); // Viagem
            addColumnFilter(11, '#filter-status-pg'); // Viagem

            addColumnFilter(12, '#filter-viagem'); // Viagem
            addColumnFilter(24, '#filter-cidade'); // Remetente
            addColumnFilter(17, '#filter-destinatario'); // Destinatario

            // Mostrar modal para adicionar novo post
            $('#addNewPostBtn').on('click', function() {
                $('#addPostIframe').attr('src', '<?php echo site_url('post-new.php?post_type=frete&classic-editor&hide_toolbar=true'); ?>');
                $('#addPostModal').modal('show');
            });

            // Fun��o para atualizar a p�gina ap�s fechar a modal
            $('#addPostModal').on('hidden.bs.modal', function () {
                location.reload();
            });

            // Remover o menu lateral e o topo do admin no iframe
            $('#addPostIframe').on('load', function() {
                var iframe = document.getElementById('addPostIframe').contentWindow;
                iframe.document.getElementById('adminmenumain').style.display = 'none';
                iframe.document.getElementById('wpadminbar').style.display = 'none';
            });

            // Mostrar modal para editar post
            $(document).on('click', '.edit-post-btn', function() {
                var postId = $(this).data('post-id');
                $('#editPostIframe').attr('src', '<?php echo admin_url('post.php?post='); ?>' + postId + '&action=edit');
                $('#editPostModal').modal('show');
            });

            // Atualizar p�gina ap�s fechar a modal de edi��o
            $('#editPostModal').on('hidden.bs.modal', function () {
                location.reload();
            });

            // Remover o menu lateral e o topo do admin no iframe de edi��o
            $('#editPostIframe').on('load', function() {
                var iframe = document.getElementById('editPostIframe').contentWindow;
                iframe.document.getElementById('adminmenumain').style.display = 'none';
                iframe.document.getElementById('wpadminbar').style.display = 'none';
            });

            // Evento para mudar a busca no WP_Query quando o filtro de data mudar
    $('#filter-data').on('change', function() {
        var periodo = $(this).val();
        var url = new URL(window.location.href);
        url.searchParams.set('periodo', periodo);

        // Adicionar classe de carregamento aos cont�ineres
        $('#filter-data-container').addClass('loading');
        $('#total-faturado-container').addClass('loading');
        $('#total-desconto-container').addClass('loading');
        $('#total-lancados-container').addClass('loading');
        $('#total-volumes-container').addClass('loading');
        $('#total-recebido-container').addClass('loading');
        $('#total-receber-container').addClass('loading');
        $('#total-dinheiro-container').addClass('loading');
        $('#total-pix-container').addClass('loading');
        $('#total-debito-container').addClass('loading');
        $('#total-credito-container').addClass('loading');
                window.location.href = url.toString();
            });

            var ajaxurl = "<?php echo admin_url('admin-ajax.php'); ?>";
        });
    </script>

    <style>
        div.dataTables_wrapper div.dataTables_filter {
            text-align: right;
            display: yes;
        }
    </style>



 
 
 <style>
    .offcanvas-end {
      width: 50%; /* Define a largura como 50% da tela */
    }
    .offcanvas-body {
      padding: 0; /* Remove o padding para que o iframe ocupe todo o espa�o */
    }
    iframe {
      width: 100%;
      height: 100vh; /* Ajusta a altura do iframe para caber na viewport */
      border: none;
    }


    #adminmenuwrap {

 
      z-index: 2;
    }




iframe {
 
    margin-top: -30px;

}

.disabled-btn {
    opacity: 0.5;
    cursor: not-allowed;
}


  </style>
 
 

 <script>
     

            $('#filter-data').on('change', function() {
                var periodo = $(this).val();
                var url = new URL(window.location.href);
                url.searchParams.set('periodo', periodo);
                window.location.href = url.toString();
            });
       



////////////PAGAMENTO


<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
 
 
<!-- Modal -->
<div class="modal fade" id="paymentModal" tabindex="-1" role="dialog" aria-labelledby="paymentModalLabel" aria-hidden="true">
 <div class="modal-dialog" role="document">
 <div class="modal-content">
 <div class="modal-header">
 <h5 class="modal-title" id="paymentModalLabel">Inserir Valores de Pagamento</h5>
 </div>
 <div class="modal-body">
 <input type="hidden" id="selected-ids">

 <div class="row">
 <div class="col-md-6">
 <div class="form-group">
 <label for="cash-amount">Valor em Dinheiro:</label>
 <input type="text" class="form-control payment-input" id="cash-amount" name="valor_dinheiro" placeholder="0,00">
 </div>
 </div>
 <div class="col-md-6">
 <div class="form-group">
 <label for="pix-amount">Valor em Pix:</label>
 <input type="text" class="form-control payment-input" id="pix-amount" name="valor_pix" placeholder="0,00">
 </div>
 </div>
 <div class="col-md-6">
 <div class="form-group">
 <label for="debit-amount">Valor em D&eacute;bito:</label>
 <input type="text" class="form-control payment-input" id="debit-amount" name="valor_debito" placeholder="0,00">
 </div>
 </div>
 <div class="col-md-6">
 <div class="form-group">
 <label for="credit-amount">Valor em Cr&eacute;dito:</label>
 <input type="text" class="form-control payment-input" id="credit-amount" name="valor_credito" placeholder="0,00">
 </div>
 </div>
 </div>
 
 <div class="form-group">
 <label for="discount-amount">Valor de Desconto:</label>
 <input type="text" class="form-control payment-input" id="discount-amount" name="valor_desconto" placeholder="0,00">
 </div>

 <p>Total a pagar: R$ <span id="total-amount">0,00</span></p>
 <p>Total informado: R$ <span id="input-total">0,00</span></p>
 <p>Total faltando: R$ <span id="missing-total">0,00</span></p>
 <p id="error-message" style="color: red; display:none;">O total informado n&atilde;o corresponde ao total a pagar!</p>
 </div>
 <div class="modal-footer">
 <button type="button" class="btn btn-primary" id="confirm-payment">Confirmar Pagamento</button>
 </div>
 </div>
 </div>
</div>



<script type="text/javascript">
    var homeurl = "<?php echo esc_url( home_url( '/' ) ); ?>";
</script>
 


 <script type="text/javascript">
/* ===========================================================
 *  Pagamento de Encomendas – Front-end completo
 *  2025 – ajustado para funcionar com DataTables paginado
 * =========================================================== */

var ajaxurl    = "<?php echo admin_url('admin-ajax.php'); ?>";
var ajax_nonce = "<?php echo wp_create_nonce('atualizar_pagamento_encomenda'); ?>";
var homeurl    = "<?php echo home_url('/'); ?>";

jQuery(function ($) {

  const maxSel = -1; // -1 = várias linhas; 1 = apenas uma linha
  const table = $('#example').DataTable(); // tabela com ID 'example'

  /* ---------- Helpers ---------- */
  const fmt = n => n.toFixed(2).replace('.', ',').replace(/\B(?=(\d{3})+(?!\d))/g, '.');
  const agora = () => {
    const d = new Date();
    return `${String(d.getDate()).padStart(2,'0')}-${String(d.getMonth()+1).padStart(2,'0')}-${d.getFullYear()} `
         + `${String(d.getHours()).padStart(2,'0')}:${String(d.getMinutes()).padStart(2,'0')}`;
  };

  /* ---------- Seleciona linhas e calcula total ---------- */
  function atualizarTotalLinhas () {
    let totalSel = 0, ids = [];

    table.rows({ search: 'applied' }).every(function () {
      const $row = $(this.node());
      const checkbox = $row.find('.select-row');
      const status = $row.find('td').eq(17).text().trim();

      if (checkbox.is(':checked')) {
        if (status !== 'Nao' && status !== '0,00') {
          checkbox.prop('checked', false);
          return;
        }

        const valor = parseFloat(
          $row.find('td').eq(18).text().replace('R$', '').replace(/\./g, '').replace(',', '.')
        ) || 0;

        totalSel += valor;
        ids.push(checkbox.data('id'));
      }
    });

    $('#total-amount').text(fmt(totalSel));
    $('#selected-ids').val(ids.join(','));
    atualizarDiferenca();
  }

  /* ---------- Formata input de moeda ---------- */
  function mascaraMoeda (el) {
    let v = el.value.replace(/\D/g, '');
    if (!v) { el.value = ''; return; }
    v = (parseFloat(v) / 100).toFixed(2).replace('.', ',').replace(/(\d)(?=(\d{3})+,)/g, '$1.');
    el.value = v;
  }

  /* ---------- Calcula pagamentos + desconto ---------- */
  function atualizarDiferenca () {
    let pagos = 0;
    $('.payment-input').each(function () {
      if (this.name === 'valor_desconto') return;
      pagos += parseFloat(this.value.replace(/\./g, '').replace(',', '.')) || 0;
    });

    const desc = parseFloat($('#discount-amount').val().replace(/\./g, '').replace(',', '.')) || 0;
    const total = parseFloat($('#total-amount').text().replace(/\./g, '').replace(',', '.')) || 0;
    const diff = total - pagos - desc;

    $('#input-total').text(fmt(pagos));
    $('#missing-total')
      .text(fmt(diff))
      .toggleClass('text-danger', Math.abs(diff) > 0.01)
      .toggleClass('text-success', Math.abs(diff) <= 0.01);
  }

  /* ---------- Eventos ---------- */
  $('#select-all').on('click', function () {
    const checked = $(this).prop('checked');
    $('.select-row').prop('checked', checked);
    atualizarTotalLinhas();
  });

  $(document).on('change', '.select-row', function () {
    if (maxSel === 1) $('.select-row').not(this).prop('checked', false);
    atualizarTotalLinhas();
  });

  $('.payment-input').on('input', function () {
    mascaraMoeda(this);
    atualizarDiferenca();
  });

  $('#pay-button').on('click', function () {
    atualizarTotalLinhas();
    if (parseFloat($('#total-amount').text().replace(',', '.')) > 0) {
      $('#paymentModal').modal('show');
    } else {
      alert('Nenhuma linha válida selecionada.');
    }
  });

  // Botão individual por linha (funciona com paginação)
  $(document).on('click', '.pay-button', function () {
    const itemId = $(this).data('id');
    let found = false;

    table.rows().every(function (rowIdx) {
      const $row = $(this.node());
      const rowId = $row.find('.select-row').data('id');

      if (rowId == itemId) {
        found = true;
        const page = Math.floor(rowIdx / table.page.len());
        table.page(page).draw(false);

        setTimeout(() => {
          $('.select-row').prop('checked', false);
          $(`.select-row[data-id="${itemId}"]`).prop('checked', true);
          atualizarTotalLinhas();
          $('#paymentModal').modal('show');
        }, 200);

        return false;
      }
    });

    if (!found) alert('Linha não encontrada.');
  });

  /* ---------- Confirmar pagamento ---------- */
  $('#confirm-payment').on('click', function () {
    const ids = $('#selected-ids').val().split(',').filter(Boolean);
    if (!ids.length) return;

    const getVal = sel =>
      parseFloat($(sel).val().replace(/\./g, '').replace(',', '.')) || 0;

    const valores = {
      dinheiro: getVal('[name="valor_dinheiro"]'),
      pix: getVal('[name="valor_pix"]'),
      debito: getVal('[name="valor_debito"]'),
      credito: getVal('[name="valor_credito"]'),
      desconto: getVal('#discount-amount')
    };

    const totalPagos = valores.dinheiro + valores.pix + valores.debito + valores.credito;
    const totalSel = parseFloat($('#total-amount').text().replace(/\./g, '').replace(',', '.')) || 0;

    if (Math.abs((totalPagos + valores.desconto) - totalSel) > 0.01) {
      $('#error-message').text('Pagamentos + desconto não conferem com o total selecionado.').show();
      return;
    }
    $('#error-message').hide();

    const partes = ids.length;
    const div = n => (n / partes).toFixed(2);

    ids.forEach(id => {
      $.post(ajaxurl, {
        action: 'atualizar_pagamento_encomenda',
        nonce: ajax_nonce,
        post_ids: id,

        valor_dinheiro: div(valores.dinheiro),
        valor_pix: div(valores.pix),
        valor_debito: div(valores.debito),
        valor_credito: div(valores.credito),
        valor_desconto: div(valores.desconto),

        valor_total_pago: div(totalPagos),
        valor_total_devido: div(totalSel - totalPagos - valores.desconto),
        data_pagamento: agora()
      }).done(r => {
        if (r.success) {
          window.location.href = `${homeurl}cencomenda?ent=ok&envio=destok&encomendaid=${id}`;
        } else {
          alert('Erro: ' + r.data);
        }
      }).fail(() => alert('Falha AJAX.'));
    });

    $('#paymentModal').modal('hide');
  });

  /* ---------- Init ---------- */
  atualizarTotalLinhas();
});
</script>




<style>

.hidden { display: none; } 


</style>

   




<script>
jQuery(document).ready(function($) {
    const table = $('#example').DataTable(); // já está inicializado

    const filters = [
        { id: 'filter-status', column: 4 },
        { id: 'filter-status-pg', column: 11 },
        { id: 'filter-viagem', column: 12 },
        { id: 'filter-destinatario', column: 17 },
        { id: 'filter-cidade', column: 24 }
    ];

    // Restaurar filtros
    filters.forEach(({ id, column }) => {
        const $select = $('#' + id);
        const savedValue = localStorage.getItem(id);

        if (savedValue) {
            $select.val(savedValue);
            table.column(column).search(savedValue ? '^' + savedValue + '$' : '', true, false).draw();
        }

        // Salvar ao mudar
        $select.on('change', function () {
            const value = $(this).val();
            localStorage.setItem(id, value);
            table.column(column).search(value ? '^' + value + '$' : '', true, false).draw();
        });
    });
});
</script>







 
 
</body>
</html>


<?php
get_footer(); // chama o footer.php do tema
